CREATE OR REPLACE FUNCTION abk__a_i__resource_create() RETURNS TRIGGER AS $$
  DECLARE

      _prefix varchar := 'TRIGGER abk__a_i__resource_create -';
      _loglevel integer := TSystem.Log_Get_LogLevel( _user => 'yes' );

  BEGIN

      -- Debug
      IF _loglevel >= 5 THEN
          RAISE NOTICE '% ab_ix:%;', _prefix, new.ab_ix;
      END IF;

      -- ABK-Ressource anlegen.
      INSERT INTO scheduling.resource( context, context_id )
           VALUES                    ( 'abk'  , new.ab_ix  );

      RETURN new;

  END $$ LANGUAGE plpgsql;
 --
 DROP TRIGGER IF EXISTS abk__a_i__resource_create ON public.abk;
 CREATE TRIGGER abk__a_i__resource_create
  AFTER INSERT ON abk
  FOR EACH ROW
  EXECUTE PROCEDURE abk__a_i__resource_create();
